# Fair E Web Host Billing Panel - Installation Guide

## Prerequisites

Before installing, ensure you have:

1. **Server Requirements:**
   - PHP 8.1 or higher
   - MySQL 5.7+ or MariaDB 10.3+
   - Apache 2.4+ or Nginx 1.18+
   - Composer (latest version)
   - SSL Certificate (Let's Encrypt recommended)

2. **PHP Extensions:**
   - PDO
   - PDO_MySQL
   - mbstring
   - curl
   - openssl
   - json
   - xml

3. **Server Access:**
   - SSH access
   - Database access
   - File system write permissions

## Step-by-Step Installation

### 1. Upload Files

Upload all files to your server. Recommended location:
```
/var/www/billing.fairewebhost.ca/
```

### 2. Install Composer Dependencies

```bash
cd /var/www/billing.fairewebhost.ca/fairpanel
composer install --no-dev --optimize-autoloader
```

### 3. Create Database

```bash
mysql -u root -p
```

```sql
CREATE DATABASE faireweb_billing26 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'faireweb_billing_adm'@'localhost' IDENTIFIED BY 'YourSecurePassword123!';
GRANT ALL PRIVILEGES ON faireweb_billing26.* TO 'faireweb_billing_adm'@'localhost';
FLUSH PRIVILEGES;
EXIT;
```

### 4. Import Database Schema

```bash
mysql -u faireweb_billing_adm -p faireweb_billing26 < database/schema.sql
```

### 5. Configure Environment

```bash
cp .env.example .env
nano .env
```

**Required Configuration:**

```env
# Application
APP_NAME="Fair E Web Host Billing"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://billing.fairewebhost.ca
APP_KEY=base64:GENERATE_NEW_KEY_HERE
ENCRYPTION_KEY=GENERATE_NEW_KEY_HERE

# Database
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=faireweb_billing26
DB_USERNAME=faireweb_billing_adm
DB_PASSWORD=YourSecurePassword123!

# Google OAuth 2.0
GOOGLE_CLIENT_ID=your_client_id.apps.googleusercontent.com
GOOGLE_CLIENT_SECRET=your_client_secret
GOOGLE_REDIRECT_URI=https://billing.fairewebhost.ca/auth/google/callback

# Google Analytics
GOOGLE_ANALYTICS_ID=G-XXXXXXXXXX
GOOGLE_TAG_MANAGER_ID=GTM-XXXXXXX

# Microsoft Clarity
MICROSOFT_CLARITY_ID=your_clarity_project_id

# Google AdSense
GOOGLE_ADSENSE_CLIENT=ca-pub-xxxxxxxxxxxxxxxx
GOOGLE_ADSENSE_SLOT=xxxxxxxxxx

# Email Configuration
MAIL_DRIVER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=billing@fairewebhost.ca
MAIL_PASSWORD=your_email_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=billing@fairewebhost.ca
MAIL_FROM_NAME="Fair E Web Host"
```

### 6. Generate Security Keys

```bash
# Generate APP_KEY
php -r "echo 'base64:' . base64_encode(random_bytes(32)) . PHP_EOL;"

# Generate ENCRYPTION_KEY
php -r "echo bin2hex(random_bytes(32)) . PHP_EOL;"
```

Add these to your `.env` file.

### 7. Set File Permissions

```bash
# Set ownership
chown -R www-data:www-data /var/www/billing.fairewebhost.ca/fairpanel

# Set directory permissions
find /var/www/billing.fairewebhost.ca/fairpanel -type d -exec chmod 755 {} \;

# Set file permissions
find /var/www/billing.fairewebhost.ca/fairpanel -type f -exec chmod 644 {} \;

# Set writable directories
chmod -R 777 /var/www/billing.fairewebhost.ca/fairpanel/storage
chmod -R 777 /var/www/billing.fairewebhost.ca/fairpanel/public/uploads

# Create required directories
mkdir -p /var/www/billing.fairewebhost.ca/fairpanel/storage/logs
mkdir -p /var/www/billing.fairewebhost.ca/fairpanel/storage/cache
mkdir -p /var/www/billing.fairewebhost.ca/fairpanel/storage/sessions
mkdir -p /var/www/billing.fairewebhost.ca/fairpanel/public/uploads
```

### 8. Configure Web Server

#### Apache Configuration

Create virtual host file: `/etc/apache2/sites-available/billing.fairewebhost.ca.conf`

```apache
<VirtualHost *:80>
    ServerName billing.fairewebhost.ca
    ServerAdmin admin@fairewebhost.ca
    DocumentRoot /var/www/billing.fairewebhost.ca/fairpanel/public

    <Directory /var/www/billing.fairewebhost.ca/fairpanel/public>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>

    ErrorLog ${APACHE_LOG_DIR}/billing_error.log
    CustomLog ${APACHE_LOG_DIR}/billing_access.log combined
</VirtualHost>
```

Enable site and modules:
```bash
a2ensite billing.fairewebhost.ca
a2enmod rewrite
systemctl restart apache2
```

#### Nginx Configuration

Create server block: `/etc/nginx/sites-available/billing.fairewebhost.ca`

```nginx
server {
    listen 80;
    server_name billing.fairewebhost.ca;
    root /var/www/billing.fairewebhost.ca/fairpanel/public;
    index index.php index.html;

    access_log /var/log/nginx/billing_access.log;
    error_log /var/log/nginx/billing_error.log;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.(?!well-known).* {
        deny all;
    }
}
```

Enable site:
```bash
ln -s /etc/nginx/sites-available/billing.fairewebhost.ca /etc/nginx/sites-enabled/
nginx -t
systemctl restart nginx
```

### 9. Install SSL Certificate

```bash
# Install Certbot
apt-get install certbot python3-certbot-apache  # For Apache
# OR
apt-get install certbot python3-certbot-nginx   # For Nginx

# Get certificate
certbot --apache -d billing.fairewebhost.ca     # For Apache
# OR
certbot --nginx -d billing.fairewebhost.ca      # For Nginx
```

### 10. Configure Google OAuth 2.0

1. Go to [Google Cloud Console](https://console.cloud.google.com)
2. Create a new project: "Fair E Web Host Billing"
3. Enable APIs:
   - Google+ API
   - Google OAuth2 API
4. Create OAuth 2.0 credentials:
   - Application type: Web application
   - Name: Fair E Web Host Billing
   - Authorized redirect URIs: `https://billing.fairewebhost.ca/auth/google/callback`
5. Copy Client ID and Client Secret to `.env`

### 11. Configure Google Analytics

1. Go to [Google Analytics](https://analytics.google.com)
2. Create account: "Fair E Web Host"
3. Create property: "Billing Portal"
4. Get Measurement ID (G-XXXXXXXXXX)
5. Add to `.env` as `GOOGLE_ANALYTICS_ID`

### 12. Configure Google Tag Manager

1. Go to [Google Tag Manager](https://tagmanager.google.com)
2. Create account: "Fair E Web Host"
3. Create container: "Billing Portal - Web"
4. Get Container ID (GTM-XXXXXXX)
5. Add to `.env` as `GOOGLE_TAG_MANAGER_ID`

### 13. Configure Microsoft Clarity

1. Go to [Microsoft Clarity](https://clarity.microsoft.com)
2. Create project: "Fair E Web Host Billing"
3. Get Project ID
4. Add to `.env` as `MICROSOFT_CLARITY_ID`

### 14. Configure Google AdSense (Optional)

1. Go to [Google AdSense](https://www.google.com/adsense)
2. Add your site
3. Get Publisher ID (ca-pub-xxxxxxxxxxxxxxxx)
4. Create ad units and get slot IDs
5. Add to `.env`

### 15. Test Installation

Visit: `https://billing.fairewebhost.ca`

You should see the login page.

**Default Admin Credentials:**
- Email: `admin@fairewebhost.ca`
- Password: `Admin@123`

**CRITICAL: Change this password immediately!**

### 16. Post-Installation Security

1. **Change Admin Password:**
   - Login with default credentials
   - Go to Account Settings
   - Change password to a strong one

2. **Verify File Permissions:**
   ```bash
   ls -la /var/www/billing.fairewebhost.ca/fairpanel/storage
   ls -la /var/www/billing.fairewebhost.ca/fairpanel/public/uploads
   ```

3. **Test Email:**
   - Register a test account
   - Verify welcome email is received

4. **Test Google OAuth:**
   - Click "Sign in with Google"
   - Verify authentication works

5. **Verify Analytics:**
   - Visit site
   - Check Google Analytics Real-Time reports
   - Check Microsoft Clarity dashboard

## Troubleshooting

### Issue: 500 Internal Server Error

**Solution:**
```bash
# Check error logs
tail -f /var/log/apache2/billing_error.log
# OR
tail -f /var/log/nginx/billing_error.log

# Check application logs
tail -f /var/www/billing.fairewebhost.ca/fairpanel/storage/logs/*.log

# Verify permissions
ls -la /var/www/billing.fairewebhost.ca/fairpanel/storage
```

### Issue: Database Connection Failed

**Solution:**
```bash
# Test database connection
mysql -u faireweb_billing_adm -p faireweb_billing26

# Verify credentials in .env
cat /var/www/billing.fairewebhost.ca/fairpanel/.env | grep DB_
```

### Issue: Google OAuth Not Working

**Solution:**
1. Verify redirect URI in Google Console matches exactly
2. Check Client ID and Secret in `.env`
3. Ensure HTTPS is enabled
4. Clear browser cache

### Issue: Composer Install Fails

**Solution:**
```bash
# Update Composer
composer self-update

# Clear cache
composer clear-cache

# Install with verbose output
composer install -vvv
```

## Maintenance

### Backup

```bash
# Backup database
mysqldump -u faireweb_billing_adm -p faireweb_billing26 > backup_$(date +%Y%m%d).sql

# Backup files
tar -czf fairpanel_backup_$(date +%Y%m%d).tar.gz /var/www/billing.fairewebhost.ca/fairpanel
```

### Updates

```bash
# Update dependencies
composer update

# Clear cache
rm -rf /var/www/billing.fairewebhost.ca/fairpanel/storage/cache/*
```

### Logs

```bash
# View application logs
tail -f /var/www/billing.fairewebhost.ca/fairpanel/storage/logs/*.log

# Rotate logs (add to crontab)
0 0 * * * find /var/www/billing.fairewebhost.ca/fairpanel/storage/logs -name "*.log" -mtime +30 -delete
```

## Support

For installation support:
- Email: support@fairewebhost.ca
- Documentation: https://docs.fairewebhost.ca

## Next Steps

After installation:
1. Read HELP.md for user documentation
2. Configure payment gateways (PayPal, Stripe)
3. Set up WHM/cPanel integration
4. Configure domain registrar API
5. Customize email templates
6. Set up automated backups
7. Configure monitoring and alerts