# Fair E Web Host Billing Panel - Quick Start Guide

## 🚀 Get Started in 5 Minutes

This guide will get your billing panel up and running quickly.

---

## Prerequisites

Before you begin, ensure you have:
- ✅ Server with PHP 8.1+
- ✅ MySQL 5.7+ or MariaDB 10.3+
- ✅ Composer installed
- ✅ Root/sudo access
- ✅ Domain pointed to server

---

## Option 1: Automated Installation (Recommended)

### Step 1: Upload Files
Upload the entire `fairpanel` directory to your server.

### Step 2: Run Installation Script
```bash
cd /path/to/fairpanel
sudo chmod +x install.sh
sudo ./install.sh
```

The script will:
- ✅ Check requirements
- ✅ Install dependencies
- ✅ Create database
- ✅ Generate security keys
- ✅ Set permissions
- ✅ Configure web server

### Step 3: Access Your Panel
Visit: `https://billing.fairewebhost.ca`

**Default Login:**
- Email: `admin@fairewebhost.ca`
- Password: `Admin@123`

**⚠️ CHANGE PASSWORD IMMEDIATELY!**

---

## Option 2: Manual Installation (5 Steps)

### Step 1: Install Dependencies
```bash
cd fairpanel
composer install --no-dev --optimize-autoloader
```

### Step 2: Configure Environment
```bash
cp .env.example .env
nano .env
```

**Update these critical settings:**
```env
DB_DATABASE=faireweb_billing26
DB_USERNAME=faireweb_billing_adm
DB_PASSWORD=your_secure_password

APP_URL=https://billing.fairewebhost.ca
```

**Generate security keys:**
```bash
# APP_KEY
php -r "echo 'base64:' . base64_encode(random_bytes(32)) . PHP_EOL;"

# ENCRYPTION_KEY
php -r "echo bin2hex(random_bytes(32)) . PHP_EOL;"
```

Add these to your `.env` file.

### Step 3: Create Database
```bash
mysql -u root -p
```

```sql
CREATE DATABASE faireweb_billing26 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'faireweb_billing_adm'@'localhost' IDENTIFIED BY 'YourPassword123!';
GRANT ALL PRIVILEGES ON faireweb_billing26.* TO 'faireweb_billing_adm'@'localhost';
FLUSH PRIVILEGES;
EXIT;
```

```bash
mysql -u faireweb_billing_adm -p faireweb_billing26 < database/schema.sql
```

### Step 4: Set Permissions
```bash
sudo chown -R www-data:www-data /path/to/fairpanel
sudo chmod -R 755 /path/to/fairpanel
sudo chmod -R 777 /path/to/fairpanel/storage
sudo chmod -R 777 /path/to/fairpanel/public/uploads
```

### Step 5: Configure Web Server

**For Apache:**
Point document root to: `/path/to/fairpanel/public`

**For Nginx:**
```nginx
server {
    listen 80;
    server_name billing.fairewebhost.ca;
    root /path/to/fairpanel/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

Restart web server:
```bash
sudo systemctl restart apache2  # or nginx
```

---

## Post-Installation (Required)

### 1. Install SSL Certificate
```bash
sudo certbot --apache -d billing.fairewebhost.ca
# OR
sudo certbot --nginx -d billing.fairewebhost.ca
```

### 2. Change Admin Password
1. Login with default credentials
2. Go to Account Settings
3. Change password to a strong one

### 3. Configure Google OAuth (Optional but Recommended)

**Get Credentials:**
1. Go to [Google Cloud Console](https://console.cloud.google.com)
2. Create project: "Fair E Web Host Billing"
3. Enable Google+ API
4. Create OAuth 2.0 credentials
5. Add redirect URI: `https://billing.fairewebhost.ca/auth/google/callback`

**Update .env:**
```env
GOOGLE_CLIENT_ID=your_client_id.apps.googleusercontent.com
GOOGLE_CLIENT_SECRET=your_client_secret
GOOGLE_REDIRECT_URI=https://billing.fairewebhost.ca/auth/google/callback
```

### 4. Configure Analytics (Optional)

**Google Analytics:**
```env
GOOGLE_ANALYTICS_ID=G-XXXXXXXXXX
```

**Google Tag Manager:**
```env
GOOGLE_TAG_MANAGER_ID=GTM-XXXXXXX
```

**Microsoft Clarity:**
```env
MICROSOFT_CLARITY_ID=your_clarity_id
```

### 5. Configure Email

**Update .env:**
```env
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=billing@fairewebhost.ca
MAIL_PASSWORD=your_app_password
MAIL_FROM_ADDRESS=billing@fairewebhost.ca
```

---

## Testing Your Installation

### Test 1: Login
- Visit your site
- Login with admin credentials
- Verify dashboard loads

### Test 2: Google OAuth
- Logout
- Click "Sign in with Google"
- Verify authentication works

### Test 3: Registration
- Click "Create Account"
- Register a test user
- Check welcome email

### Test 4: Analytics
- Visit site
- Check Google Analytics Real-Time
- Verify tracking works

---

## Common Issues & Solutions

### Issue: 500 Error
**Solution:**
```bash
# Check logs
tail -f storage/logs/*.log

# Verify permissions
ls -la storage/
```

### Issue: Database Connection Failed
**Solution:**
```bash
# Test connection
mysql -u faireweb_billing_adm -p faireweb_billing26

# Verify .env
cat .env | grep DB_
```

### Issue: Composer Install Fails
**Solution:**
```bash
composer self-update
composer clear-cache
composer install -vvv
```

---

## Next Steps

### Configure Payment Gateways

**PayPal:**
```env
PAYPAL_MODE=live
PAYPAL_CLIENT_ID=your_client_id
PAYPAL_CLIENT_SECRET=your_secret
```

**Stripe:**
```env
STRIPE_PUBLIC_KEY=pk_live_xxxxxxxx
STRIPE_SECRET_KEY=sk_live_xxxxxxxx
```

### Configure WHM/cPanel

```env
WHM_HOST=server.yourdomain.com
WHM_USERNAME=root
WHM_API_TOKEN=your_token
```

### Configure Domain Registrar

```env
RESELLERCLUB_AUTH_USERID=your_id
RESELLERCLUB_API_KEY=your_key
```

---

## Important Security Notes

### 1. Change Default Password ⚠️
The default admin password MUST be changed immediately.

### 2. Secure .env File
```bash
chmod 600 .env
```

### 3. Enable HTTPS
Always use SSL certificate in production.

### 4. Regular Backups
Set up automated daily backups:
```bash
# Database
mysqldump -u faireweb_billing_adm -p faireweb_billing26 > backup.sql

# Files
tar -czf fairpanel_backup.tar.gz /path/to/fairpanel
```

### 5. Monitor Logs
```bash
tail -f storage/logs/*.log
```

---

## Getting Help

### Documentation
- **README.md** - Overview
- **INSTALLATION.md** - Detailed installation
- **DEPLOYMENT.md** - Production deployment
- **HELP.md** - User guide
- **PROJECT_SUMMARY.md** - Technical details

### Support
- **Email:** support@fairewebhost.ca
- **Emergency:** 24/7 for critical issues

### Troubleshooting
See INSTALLATION.md for detailed troubleshooting guide.

---

## Quick Reference

### File Locations
- **Application:** `/path/to/fairpanel/`
- **Web Root:** `/path/to/fairpanel/public/`
- **Logs:** `/path/to/fairpanel/storage/logs/`
- **Config:** `/path/to/fairpanel/.env`

### Default Credentials
- **Email:** admin@fairewebhost.ca
- **Password:** Admin@123 (CHANGE THIS!)

### Database
- **Name:** faireweb_billing26
- **User:** faireweb_billing_adm

### URLs
- **Site:** https://billing.fairewebhost.ca
- **Admin:** https://billing.fairewebhost.ca/admin/dashboard
- **Client:** https://billing.fairewebhost.ca/client/dashboard

---

## Checklist

Before going live, ensure:
- [ ] Installation completed successfully
- [ ] Default password changed
- [ ] SSL certificate installed
- [ ] .env file configured
- [ ] Google OAuth working (if enabled)
- [ ] Email sending working
- [ ] Analytics tracking (if enabled)
- [ ] Backups configured
- [ ] Monitoring set up
- [ ] Documentation reviewed

---

## Success! 🎉

Your Fair E Web Host Billing Panel is now ready to use!

**What's Next?**
1. Customize email templates
2. Add hosting packages
3. Configure payment gateways
4. Set up WHM integration
5. Train your team
6. Start accepting customers!

---

**For detailed information, see the complete documentation files.**

**Version:** 1.0.0 | **Status:** Production Ready | **Date:** January 2026