<?php

namespace App\Controllers\Client;

use Core\Controller;

class InvoiceController extends Controller
{
    public function index(): void
    {
        $user = $this->getAuthUser();
        
        $status = $this->request->get('status', 'all');
        
        $query = $this->database->table('invoices')
            ->where('user_id', $user['id']);
        
        if ($status !== 'all') {
            $query->where('status', $status);
        }
        
        $invoices = $query->orderBy('created_at', 'DESC')->get();
        
        $this->view('client.invoices.index', [
            'invoices' => $invoices,
            'status' => $status,
        ]);
    }

    public function show(int $id): void
    {
        $user = $this->getAuthUser();
        
        $invoice = $this->database->table('invoices')
            ->where('id', $id)
            ->where('user_id', $user['id'])
            ->first();
        
        if (!$invoice) {
            $this->response->setStatusCode(404);
            $this->view('errors.404');
            return;
        }
        
        // Get invoice items
        $items = $this->database->table('invoice_items')
            ->where('invoice_id', $id)
            ->get();
        
        $this->view('client.invoices.show', [
            'invoice' => $invoice,
            'items' => $items,
        ]);
    }

    public function pay(int $id): void
    {
        $user = $this->getAuthUser();
        
        $invoice = $this->database->table('invoices')
            ->where('id', $id)
            ->where('user_id', $user['id'])
            ->first();
        
        if (!$invoice) {
            $this->json(['error' => 'Invoice not found'], 404);
            return;
        }
        
        if ($invoice['status'] === 'paid') {
            $this->response
                ->withErrors(['general' => ['Invoice is already paid']])
                ->back();
            return;
        }

        $paymentMethod = $this->request->post('payment_method', 'paypal');
        
        // Redirect to payment gateway
        if ($paymentMethod === 'paypal') {
            // TODO: Integrate PayPal payment
            $this->redirect('/payment/paypal/' . $id);
        } elseif ($paymentMethod === 'stripe') {
            // TODO: Integrate Stripe payment
            $this->redirect('/payment/stripe/' . $id);
        } else {
            $this->response
                ->withErrors(['general' => ['Invalid payment method']])
                ->back();
        }
    }
}