<?php

namespace App\Models;

use Core\Model;

class Domain extends Model
{
    protected string $table = 'domains';
    protected string $primaryKey = 'id';
    
    protected array $fillable = [
        'user_id',
        'domain',
        'registrar',
        'status',
        'registration_date',
        'expiry_date',
        'auto_renew',
        'price',
        'nameserver1',
        'nameserver2',
        'nameserver3',
        'nameserver4',
        'epp_code',
        'notes',
    ];
    
    protected array $casts = [
        'id' => 'int',
        'user_id' => 'int',
        'price' => 'float',
        'auto_renew' => 'bool',
    ];
    
    protected bool $timestamps = true;

    public function user(): ?array
    {
        return $this->db->table('users')
            ->where('id', $this->user_id ?? 0)
            ->first();
    }

    public function isActive(): bool
    {
        $domain = $this->find($this->id ?? 0);
        return $domain && $domain['status'] === 'active';
    }

    public function isExpired(): bool
    {
        $domain = $this->find($this->id ?? 0);
        if (!$domain || !$domain['expiry_date']) {
            return false;
        }
        
        return strtotime($domain['expiry_date']) < time();
    }

    public function isExpiringSoon(int $days = 30): bool
    {
        $domain = $this->find($this->id ?? 0);
        if (!$domain || !$domain['expiry_date']) {
            return false;
        }
        
        $expiryTime = strtotime($domain['expiry_date']);
        $warningTime = time() + ($days * 86400);
        
        return $expiryTime <= $warningTime && $expiryTime > time();
    }

    public function getDaysUntilExpiry(): ?int
    {
        $domain = $this->find($this->id ?? 0);
        if (!$domain || !$domain['expiry_date']) {
            return null;
        }
        
        $diff = strtotime($domain['expiry_date']) - time();
        return (int)floor($diff / 86400);
    }
}