<?php

namespace App\Models;

use Core\Model;

class HostingAccount extends Model
{
    protected string $table = 'hosting_accounts';
    protected string $primaryKey = 'id';
    
    protected array $fillable = [
        'user_id',
        'server_id',
        'package_id',
        'domain',
        'username',
        'status',
        'billing_cycle',
        'next_due_date',
        'price',
        'disk_limit',
        'bandwidth_limit',
        'email_limit',
        'database_limit',
        'subdomain_limit',
        'addon_domain_limit',
        'cpanel_username',
        'cpanel_password',
        'notes',
    ];
    
    protected array $hidden = [
        'cpanel_password',
    ];
    
    protected array $casts = [
        'id' => 'int',
        'user_id' => 'int',
        'server_id' => 'int',
        'package_id' => 'int',
        'price' => 'float',
        'disk_limit' => 'int',
        'bandwidth_limit' => 'int',
        'email_limit' => 'int',
        'database_limit' => 'int',
        'subdomain_limit' => 'int',
        'addon_domain_limit' => 'int',
    ];
    
    protected bool $timestamps = true;

    public function user(): ?array
    {
        return $this->db->table('users')
            ->where('id', $this->user_id ?? 0)
            ->first();
    }

    public function server(): ?array
    {
        return $this->db->table('servers')
            ->where('id', $this->server_id ?? 0)
            ->first();
    }

    public function isActive(): bool
    {
        $account = $this->find($this->id ?? 0);
        return $account && $account['status'] === 'active';
    }

    public function isSuspended(): bool
    {
        $account = $this->find($this->id ?? 0);
        return $account && $account['status'] === 'suspended';
    }

    public function suspend(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'suspended',
        ]) > 0;
    }

    public function unsuspend(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'active',
        ]) > 0;
    }

    public function terminate(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'terminated',
        ]) > 0;
    }
}