<?php

namespace App\Models;

use Core\Model;

class Order extends Model
{
    protected string $table = 'orders';
    protected string $primaryKey = 'id';
    
    protected array $fillable = [
        'user_id',
        'order_number',
        'status',
        'total_amount',
        'payment_method',
        'payment_status',
        'notes',
    ];
    
    protected array $casts = [
        'id' => 'int',
        'user_id' => 'int',
        'total_amount' => 'float',
    ];
    
    protected bool $timestamps = true;

    public function user(): ?array
    {
        return $this->db->table('users')
            ->where('id', $this->user_id ?? 0)
            ->first();
    }

    public function isPending(): bool
    {
        $order = $this->find($this->id ?? 0);
        return $order && $order['status'] === 'pending';
    }

    public function isCompleted(): bool
    {
        $order = $this->find($this->id ?? 0);
        return $order && $order['status'] === 'completed';
    }

    public function approve(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'completed',
        ]) > 0;
    }

    public function cancel(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'cancelled',
        ]) > 0;
    }

    public static function generateOrderNumber(): string
    {
        $prefix = 'ORD';
        $date = date('Ymd');
        $random = str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
        
        return $prefix . '-' . $date . '-' . $random;
    }
}