<?php

namespace App\Models;

use Core\Model;

class Transaction extends Model
{
    protected string $table = 'transactions';
    protected string $primaryKey = 'id';
    
    protected array $fillable = [
        'user_id',
        'invoice_id',
        'transaction_id',
        'gateway',
        'amount',
        'currency',
        'status',
        'payment_method',
        'notes',
    ];
    
    protected array $casts = [
        'id' => 'int',
        'user_id' => 'int',
        'invoice_id' => 'int',
        'amount' => 'float',
    ];
    
    protected bool $timestamps = false;

    public function user(): ?array
    {
        return $this->db->table('users')
            ->where('id', $this->user_id ?? 0)
            ->first();
    }

    public function invoice(): ?array
    {
        if (!$this->invoice_id) {
            return null;
        }
        
        return $this->db->table('invoices')
            ->where('id', $this->invoice_id)
            ->first();
    }

    public function isCompleted(): bool
    {
        $transaction = $this->find($this->id ?? 0);
        return $transaction && $transaction['status'] === 'completed';
    }

    public function isPending(): bool
    {
        $transaction = $this->find($this->id ?? 0);
        return $transaction && $transaction['status'] === 'pending';
    }

    public function isFailed(): bool
    {
        $transaction = $this->find($this->id ?? 0);
        return $transaction && $transaction['status'] === 'failed';
    }

    public function markCompleted(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'completed',
        ]) > 0;
    }

    public function markFailed(string $reason = ''): bool
    {
        if (!$this->id) {
            return false;
        }
        
        return $this->update($this->id, [
            'status' => 'failed',
            'notes' => $reason,
        ]) > 0;
    }
}