<?php

namespace App\Models;

use Core\Model;

class User extends Model
{
    protected string $table = 'users';
    protected string $primaryKey = 'id';
    
    protected array $fillable = [
        'google_id',
        'email',
        'password',
        'first_name',
        'last_name',
        'company',
        'phone',
        'address',
        'city',
        'state',
        'zip',
        'country',
        'role',
        'status',
        'is_admin',
        'email_verified',
        'last_login',
        'last_login_ip',
    ];
    
    protected array $hidden = [
        'password',
    ];
    
    protected array $casts = [
        'id' => 'int',
        'is_admin' => 'bool',
        'email_verified' => 'bool',
    ];
    
    protected bool $timestamps = true;

    public function getFullName(): string
    {
        $user = $this->find($this->id ?? 0);
        return ($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? '');
    }

    public function isAdmin(): bool
    {
        $user = $this->find($this->id ?? 0);
        return $user && ($user['role'] === 'admin' || $user['is_admin'] == 1);
    }

    public function isActive(): bool
    {
        $user = $this->find($this->id ?? 0);
        return $user && $user['status'] === 'active';
    }

    public function hostingAccounts(): array
    {
        return $this->db->table('hosting_accounts')
            ->where('user_id', $this->id ?? 0)
            ->get();
    }

    public function invoices(): array
    {
        return $this->db->table('invoices')
            ->where('user_id', $this->id ?? 0)
            ->get();
    }

    public function tickets(): array
    {
        return $this->db->table('tickets')
            ->where('user_id', $this->id ?? 0)
            ->get();
    }

    public static function findByEmail(string $email): ?array
    {
        $model = new self();
        return $model->where('email', $email)->first();
    }

    public static function findByGoogleId(string $googleId): ?array
    {
        $model = new self();
        return $model->where('google_id', $googleId)->first();
    }
}