<?php
$pageTitle = 'Dashboard';
require __DIR__ . '/../layouts/header.php';
?>

<div class="container-fluid py-4">
    <!-- Welcome Message -->
    <div class="row mb-4">
        <div class="col-12">
            <h2>Welcome back, <?= e($user['first_name']) ?>!</h2>
            <p class="text-muted">Here's an overview of your account</p>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h5 class="card-title">Active Services</h5>
                    <h2><?= count($services) ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title">Domains</h5>
                    <h2><?= count($domains) ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h5 class="card-title">Unpaid Invoices</h5>
                    <h2><?= count($unpaidInvoices) ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h5 class="card-title">Open Tickets</h5>
                    <h2><?= count(array_filter($recentTickets, fn($t) => $t['status'] !== 'closed')) ?></h2>
                </div>
            </div>
        </div>
    </div>

    <!-- Unpaid Invoices Alert -->
    <?php if (!empty($unpaidInvoices)): ?>
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-warning">
                <h5><i class="fas fa-exclamation-triangle"></i> You have <?= count($unpaidInvoices) ?> unpaid invoice(s)</h5>
                <p>Please pay your outstanding invoices to avoid service interruption.</p>
                <a href="/client/invoices?status=unpaid" class="btn btn-warning">View Invoices</a>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="row">
        <!-- Services -->
        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Your Services</h5>
                    <a href="/client/services" class="btn btn-sm btn-primary">View All</a>
                </div>
                <div class="card-body">
                    <?php if (empty($services)): ?>
                        <p class="text-muted">No services yet</p>
                    <?php else: ?>
                        <div class="list-group">
                            <?php foreach (array_slice($services, 0, 5) as $service): ?>
                            <a href="/client/services/<?= $service['id'] ?>" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?= e($service['domain']) ?></h6>
                                    <span class="badge bg-<?= $service['status'] === 'active' ? 'success' : 'warning' ?>">
                                        <?= ucfirst($service['status']) ?>
                                    </span>
                                </div>
                                <p class="mb-1 small text-muted">
                                    Next due: <?= date_format_custom($service['next_due_date'], 'M d, Y') ?>
                                </p>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Recent Tickets -->
        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Recent Tickets</h5>
                    <a href="/client/tickets" class="btn btn-sm btn-primary">View All</a>
                </div>
                <div class="card-body">
                    <?php if (empty($recentTickets)): ?>
                        <p class="text-muted">No tickets yet</p>
                        <a href="/client/tickets/create" class="btn btn-primary">Open New Ticket</a>
                    <?php else: ?>
                        <div class="list-group">
                            <?php foreach ($recentTickets as $ticket): ?>
                            <a href="/client/tickets/<?= $ticket['id'] ?>" class="list-group-item list-group-item-action">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?= e($ticket['subject']) ?></h6>
                                    <span class="badge bg-<?= $ticket['status'] === 'closed' ? 'secondary' : 'primary' ?>">
                                        <?= ucfirst($ticket['status']) ?>
                                    </span>
                                </div>
                                <p class="mb-1 small text-muted">
                                    <?= e($ticket['ticket_number']) ?> - <?= time_ago($ticket['created_at']) ?>
                                </p>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Announcements -->
    <?php if (!empty($announcements)): ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Announcements</h5>
                </div>
                <div class="card-body">
                    <?php foreach ($announcements as $announcement): ?>
                    <div class="mb-3">
                        <h6><?= e($announcement['title']) ?></h6>
                        <p class="text-muted small"><?= date_format_custom($announcement['created_at'], 'M d, Y') ?></p>
                        <p><?= nl2br(e($announcement['content'])) ?></p>
                    </div>
                    <?php if (!$loop->last): ?>
                        <hr>
                    <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php require __DIR__ . '/../layouts/footer.php'; ?>